// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;

//-------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float4 ViewProjInv1;
   float4 ViewProjInv2;
   float4 ViewProjInv3;
   float4 ViewProjInv4;
   float4 BoxNoise;
   float4 ReflectionPos[64];
   float4 ReflectionSize[64];

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MipFilter=None;
	MinFilter=None;
	MagFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex0:TEXCOORD0;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Proj:TEXCOORD0;
 	float4 ClipSpace:TEXCOORD1;
	float CubeIdx:TEXCOORD2;
 	float3 BoxPos:TEXCOORD3;
	float3 BoxMax:TEXCOORD4;
	float3 BoxMin:TEXCOORD5;
	float Padding:TEXCOORD6;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(IN.Pos,WorldVP); 
        OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
        OUT.ClipSpace=float4(OUT.Pos.x,-OUT.Pos.y,OUT.Pos.z,OUT.Pos.w);
	int ArrayIdx=floor(IN.Tex0.x);
	OUT.CubeIdx=ReflectionPos[ArrayIdx].w;
        OUT.BoxPos=ReflectionPos[ArrayIdx].xyz;
	OUT.BoxMax=ReflectionSize[ArrayIdx].xyz*0.5;
	OUT.BoxMin=-ReflectionSize[ArrayIdx].xyz*0.5;
	OUT.Padding=ReflectionSize[ArrayIdx].w;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float4x4 ViewProjInv=float4x4(ViewProjInv1,ViewProjInv2,ViewProjInv3,ViewProjInv4);
	float Depth=tex2Dlod(DepthSampler,((IN.Proj/IN.Proj.w)*ViewSize2)+ViewSize1);
	float4 WorldPos=mul(float4(IN.ClipSpace.xy/IN.ClipSpace.w,Depth,1),ViewProjInv);
	WorldPos.xyz=IN.BoxPos-(WorldPos.xyz/WorldPos.w);
    	float Noise=frac(52.9829*frac(dot((IN.Proj.xy/IN.Proj.w)*BoxNoise.xy,BoxNoise.zw)));
	IN.BoxMax -=Noise*IN.Padding, IN.BoxMin +=Noise*IN.Padding;
	float3 Padding=min((IN.BoxMax-WorldPos.xyz)/1.0,-(IN.BoxMin-WorldPos.xyz)/1.0);
	Padding.x=min(min(Padding.x,Padding.y),Padding.z);
	if(Padding.x<=0.0) discard;
	return IN.CubeIdx/255.0;
     }

//--------------
// techniques   
//--------------
    technique ReflectionBox
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
        ColorWriteEnable=1;
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }